-- RCPNT_TYPE_STUDENT_DTP

set sql_safe_updates=0;

SET @studentDtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_STUDENT_DTP');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T3.`firstName` AS FIRST_NAME,
    T3.`middleName` AS MIDDLE_NAME,
    T3.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    admission T1
        INNER JOIN
    students T2 ON T2.userId = T1.studentId
        INNER JOIN
    `persons` T3 ON T3.id = T2.personId
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T2.userId
WHERE
    T1.id IN (namedParams) group by T1.id"
WHERE
    `dataProviderId` = @studentDtproviderId;

    
-- RCPNT_TYPE_COMMITTEE

SET @comDtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_COMMITTEE');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1 
	INNER JOIN
	`staffs` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
    LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.`userId`
WHERE
    T1.id IN (namedParams) group by T1.id

UNION
SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1 
	INNER JOIN
	`students` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
     LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.`userId`
WHERE
    T1.id IN (namedParams) group by T1.id

UNION
SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	T2.`mobileCountryCode` AS MOBILE_CODE,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1 
	INNER JOIN
	`parents` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
     LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.`userId`
WHERE
    T1.id IN (namedParams) group by T1.id"
WHERE
    `dataProviderId` = @comDtproviderId;    
    

   
-- RCPNT_TYPE_FACULTY_DTP

SET @facDtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_FACULTY_DTP');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T2.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
    T2.`mobileCountryCode` AS MOBILE_CODE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    staffs T1
        INNER JOIN
    persons T2 ON T2.id = T1.personId
        LEFT JOIN
    salutations T3 ON T3.`id` = T2.salutationId
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T1.userId
WHERE
    T1.userId IN (namedParams) group by T1.userId"
WHERE
    `dataProviderId` = @facDtproviderId;    
    

-- RCPNT_TYPE_USER_DTP

SET @usrDtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='RCPNT_TYPE_USER_DTP');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T2.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T2.`firstName` AS FIRST_NAME,
    T2.`middleName` AS MIDDLE_NAME,
    T2.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.`mobileCountryCode` AS MOBILE_CODE,
    T3.`alternateEmailId` AS ALTERNATE_EMAIL_ID,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `staffs` T1
        INNER JOIN
    `users` T2 ON T2.`id` = T1.`userId`
        INNER JOIN
    `persons` T3 ON T3.`id` = T1.`personId`
        LEFT JOIN
    `salutations` T4 ON T4.`id` = T3.`salutationId`
		LEFT JOIN
    fire_base_persons_info f ON f.userId = T1.userId
WHERE
    T2.id IN (namedParams) group by T1.userId"
WHERE
    `dataProviderId` = @usrDtproviderId;  

-- HOSTEL_MANAGE_ALLOCATION_RECIPIENT_DTP

SET @hostelDtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='HOSTEL_MANAGE_ALLOCATION_RECIPIENT_DTP');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.mobileCountryCode AS MOBILE_CODE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    users T1
        INNER JOIN
    staffs T2 ON T1.id = T2.userId
        LEFT JOIN
    persons T3 ON T2.personId = T3.id
        LEFT JOIN
    salutations T4 ON T3.salutationId = T4.id
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T1.id
WHERE
    T1.id IN (namedParams)
GROUP BY T1.id 
UNION SELECT 
    T1.id AS ID,
    T4.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T3.`emailId` AS EMAIL_ID,
    T3.`mobileNumber` AS MOBILE_NO,
    T3.mobileCountryCode AS MOBILE_CODE,
    GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    users T1
        INNER JOIN
    students T2 ON T1.id = T2.userId
        LEFT JOIN
    persons T3 ON T2.personId = T3.id
        LEFT JOIN
    salutations T4 ON T3.salutationId = T4.id
        LEFT JOIN
    fire_base_persons_info f ON f.userId = T1.id
WHERE
    T1.id IN (namedParams)
GROUP BY T1.id"
WHERE
    `dataProviderId` = @hostelDtproviderId; 

-- COMMITTEE_ADHOC

SET @hostelDtproviderId=(SELECT id FROM dtprovider WHERE `dataProviderName`='COMMITTEE_ADHOC');
UPDATE `sql_dtprovider` 
SET 
    `sqlQuery` = "SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
	GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID	
FROM
    `users` T1 
	INNER JOIN
	`staffs` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.userId
WHERE
    T1.id IN (namedParams) group by T1.id

UNION
SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1 
	INNER JOIN
	`students` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.userId
WHERE
    T1.id IN (namedParams) group by T1.id

UNION
SELECT 
    T1.id AS ID,
    T3.`salutationName` AS SALUTATION_NAME,
    T1.`firstName` AS FIRST_NAME,
    T1.`middleName` AS MIDDLE_NAME,
    T1.`lastName` AS LAST_NAME,
    T2.`emailId` AS EMAIL_ID,
    T2.`mobileNumber` AS MOBILE_NO,
GROUP_CONCAT(DISTINCT f.deviceTokenId) AS DEVICE_ID
FROM
    `users` T1 
	INNER JOIN
	`parents` T4 ON T4.`userId` = T1.`id`
	LEFT JOIN
    `persons` T2 ON T2.`id` = T4.`personId`
	LEFT JOIN
    `salutations` T3 ON T3.`id` = T2.`salutationId`
LEFT JOIN
    fire_base_persons_info f ON f.userId = T4.userId
WHERE
    T1.id IN (namedParams) group by T1.id"
WHERE
    `dataProviderId` = @hostelDtproviderId; 
    
set sql_safe_updates=1;

